/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_31_H__
#define __REG_31_H__
/* ***********************************************************************
   *                                                                     *
   * regx31.h                                                            *
   * Tilmann Wendel , BID R&D, 22. Oct. 1997                             *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   * non lockable actions (read from status registers)                   *
   *                                                                     *
   ***********************************************************************
*/

#include "regxdir.h"

#define MERGE_TRCACTION_NOLOCK(cmd)	CMD_MERGE (CMDG_TRACEACTION_NOLOCK,cmd)

/* status read */

/* BestTraceStatusGet */
#define CMDM_TRC_STAT_READ		0x05
#define CMD_TRC_STAT_READ		MERGE_TRCACTION_NOLOCK (CMDM_TRC_STAT_READ)
#define OUT_TRC_STATUS			4
#define IN_TRC_STATUS			4

/* BestTraceDataGet */
#define CMDM_TRC_DATA_READ		0x10
#define CMD_TRC_DATA_READ		MERGE_TRCACTION_NOLOCK (CMDM_TRC_DATA_READ)
#define IN_TRC_DATA			8 /* start address and num of lines */
#define OUT_TRC_DATA			B_LENGTH_NEGOTIATE  /* we do not know*/

/* BestTraceMemorySizeGet */
#define CMDM_TRC_MEMSIZEGET		0x20
#define CMD_TRC_MEMSIZEGET		MERGE_TRCACTION_NOLOCK (CMDM_TRC_MEMSIZEGET)
#define OUT_TRC_MEMSIZEGET		4
#define IN_TRC_MEMSIZEGET		0

/* more to come.... */

#endif
